////////////////////////////////////////////////////////////////////
//
//	Class QuickProdStats
//
//		Utility to assist evaluations of clusters
//
//

package Alkindi.Services.InternalData;

/* 
$Header: QuickProdStats.java, 13, 4/26/01 2:36:58 PM, Schwartz, Joe$
$Log: 
 13   Alkindi Development1.12        4/26/01 2:36:58 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 12   Alkindi Development1.11        4/26/01 1:46:06 PM   Schwartz, Joe   Moved
      to new package.
 11   Alkindi Development1.10        1/26/01 5:48:29 PM   Schwartz, Joe  
      Improving efficiency.
 10   Alkindi Development1.9         1/23/01 1:45:47 PM   Schwartz, Joe  
      Modified to work with floats instead of doubles.
 9    Alkindi Development1.8         1/2/01 3:35:51 PM    Schwartz, Joe  
      Replaced comparable interface for class definition to activate calls to
      compareTo(). This interface was removed by accident. 
      Added argument type checks to compareTo() and equals().
 8    Alkindi Development1.7         12/28/00 1:07:27 PM  Schwartz, Joe   Added
      Version Control header info.
 7    Alkindi Development1.6         12/26/00 6:57:14 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/18/00 12:06:25 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 5    Alkindi Development1.4         12/15/00 6:23:34 PM  Schwartz, Joe   
 4    Alkindi Development1.3         12/5/00 1:21:19 PM   Schwartz, Joe   
 3    Alkindi Development1.2         12/2/00 1:02:00 PM   Schwartz, Joe   
 2    Alkindi Development1.1         11/22/00 6:50:44 PM  Schwartz, Joe  
      Modified to use different scoring function per ES request.
 1    Alkindi Development1.0         10/27/00 3:44:29 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This represents an object used to quickly calcuate statistics for a single product. it is used during the Clustering process.
 */
public class QuickProdStats implements Comparable, Cloneable 
{
	protected float badEvals = 0;
	protected float evalSum = 0;
	protected float goodEvals = 0;
	protected float sum1 = 0;
	protected float sum2 = 0;
	protected float sum3 = 0;
	protected float sum4 = 0;
	protected float sum5 = 0;
	protected float sum6 = 0;
	protected float totalEvals = 0;
	private static final QuickProdStats qpsInstance = new QuickProdStats();
	
	/**
	 * @roseuid 3A29180B003E
	 */
	public final void addEval(final float eval) 
	{
		if (eval < 1) {
			return;
		}
		if (eval > 4) {
			goodEvals ++;
		}
		else {
			badEvals ++;
		}
		evalSum += eval;
		totalEvals ++;
		//	Add eval to proper bucket for scoring later
		//
		switch((int)eval)  {
			case 1:
			sum1++;
			break;
			
			case 2:
			sum2++;
			break;
				
			case 3:
			sum3++;
			break;
			
			case 4:
			sum4++;
			break;
			
			case 5:
			sum5++;
			break;
			
			case 6:
			sum6++;
			break;
		}
	}
	
	/**
	 * @roseuid 3A291834038A
	 */
	public final void addFrom(QuickProdStats src) 
	{
		this.evalSum += src.getEvalSum();
		this.totalEvals += src.getTotalEvals();
		this.goodEvals += src.getGoodEvals();
		this.badEvals += src.getBadEvals();
	}
	
	/**
	 * Provides an override of java.lang.Object.compareTo() for the interfaces which require "natural ordering." This is used by the QuickProdStatsList collection class. for instance. It sorts the QPS obejcts by the value of returned by score1().
	 * @roseuid 3A29185E01B5
	 */
	public final int compareTo(Object objCompare) 
	{
		//	Optimizations: 
		//
		//		1. Instead of using isntanceOf we catch ClassCastException
		//		2. Do comparison of primitive types here instead of 
		//			in instance method.

		int rc = 0;
		try { 
			float thisScore1 = getScore1();
			float thatScore1 = ((QuickProdStats)objCompare).getScore1();
			if (thisScore1 > thatScore1)
				rc = 1;
			else if (thisScore1 < thatScore1)
				rc = -1;
		}
		catch (ClassCastException cce) {
			//	If objCompare is not an instance of the correct type, then 
			//	the current one is considered greater.
			//
			System.out.println("QPS ERROR: objCompare is " + objCompare.getClass().getName());
			rc = 1;
		}
		return rc;
	}
	
	/**
	 * Provides simple equality testing. Overrides java.lang.Object.equals().
	 * @roseuid 3A5215DA03B9
	 */
	public final boolean equals(java.lang.Object src) 
	{
		//	This object is never equal to one of a different type.
		//
		if (!(src instanceof QuickProdStats))
			return false;
		// 	If both objects are instances of QuickProdStats, perform
		//	a simple field comparison.
		//
		return (this == (QuickProdStats)src);
	}
	
	/**
	 * @roseuid 3A2917C7034B
	 */
	public final float getAvgEval() 
	{
		return (evalSum == 0) ? 0 : (evalSum / totalEvals);
	}
	
	/**
	 * @roseuid 3A2917AB032C
	 */
	public final float getBadEvals() 
	{
		return badEvals;
	}
	
	/**
	 * @roseuid 3A2917B30196
	 */
	public final float getEvalSum() 
	{
		return evalSum;
	}
	
	/**
	 * @roseuid 3A2917A50232
	 */
	public final float getGoodEvals() 
	{
		return goodEvals;
	}
	
	/**
	 * @roseuid 3A719EF6035B
	 */
	public static final QuickProdStats getInstance() 
	{
		try {
			return (QuickProdStats)qpsInstance.clone();
		}
		catch(CloneNotSupportedException cne) {
			return null;
		}
	}
	
	/**
	 * @roseuid 3A2917F90213
	 */
	public final float getScore1() 
	{
		return ((-3 * sum1) + (-2 * sum2) + (-1 * sum3) + sum5 + 2 * sum6);
	}
	
	/**
	 * @roseuid 3A2917B80000
	 */
	public final float getTotalEvals() 
	{
		return totalEvals;
	}
	
	/**
	 * @roseuid 3A291862034B
	 */
	public final java.lang.String toString() 
	{
		 return new String(" good=" + getGoodEvals() + " bad=" + getBadEvals() + "sum=" + evalSum + " total=" + totalEvals + " avg=" + getAvgEval());
	}
}
